
// ScienceCamp-2014View.cpp : implementation of the CScienceCamp2014View class
//

#include "stdafx.h"
// SHARED_HANDLERS can be defined in an ATL project implementing preview, thumbnail
// and search filter handlers and allows sharing of document code with that project.
#ifndef SHARED_HANDLERS
#include "ScienceCamp-2014.h"
#endif

#include "ScienceCamp-2014Doc.h"
#include "ScienceCamp-2014View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CScienceCamp2014View

IMPLEMENT_DYNCREATE(CScienceCamp2014View, CFormView)

BEGIN_MESSAGE_MAP(CScienceCamp2014View, CFormView)
	ON_BN_CLICKED(IDC_BTN_ENCRYPT, &CScienceCamp2014View::OnBnClickedBtnEncrypt)
	ON_BN_CLICKED(IDC_BTN_DECRYPT, &CScienceCamp2014View::OnBnClickedBtnDecrypt)
	ON_BN_CLICKED(IDC_BTN_ANALYZE, &CScienceCamp2014View::OnBnClickedBtnAnalyze)
END_MESSAGE_MAP()

// CScienceCamp2014View construction/destruction

CScienceCamp2014View::CScienceCamp2014View()
	: CFormView(CScienceCamp2014View::IDD)
{
	// TODO: add construction code here

}

CScienceCamp2014View::~CScienceCamp2014View()
{
}

void CScienceCamp2014View::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_RDO_NONE, mBtnNone);
	DDX_Control(pDX, IDC_RDO_ANALYSISNONE, mBtnAnalyzeNone);
	DDX_Control(pDX, IDC_BTN_ENCRYPT, mBtnEncrypt);
	DDX_Control(pDX, IDC_BTN_DECRYPT, mBtnDecrypt);
	DDX_Control(pDX, IDC_BTN_ANALYZE, mBtnAnalyze);
	DDX_Control(pDX, IDC_TXT_PLAIN, mTxtPlain);
	DDX_Control(pDX, IDC_TXT_CYPHERTXT, mTxtCypher);
	DDX_Control(pDX, IDC_STC_KEYNAME, mLblKey);
	DDX_Control(pDX, IDC_LBL_CYPHER, mLblCypher);
	DDX_Control(pDX, IDC_TXT_KEY, mTxtKey);
	DDX_Control(pDX, IDC_CHK_PRESERVE, mChkPreserve);
}

BOOL CScienceCamp2014View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CScienceCamp2014View::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	ResizeParentToFit();

	this->mBtnNone.SetCheck(1);
	this->mBtnAnalyzeNone.SetCheck(1);

	//ResizeControls();
}


// CScienceCamp2014View diagnostics

#ifdef _DEBUG
void CScienceCamp2014View::AssertValid() const
{
	CFormView::AssertValid();
}

void CScienceCamp2014View::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CScienceCamp2014Doc* CScienceCamp2014View::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CScienceCamp2014Doc)));
	return (CScienceCamp2014Doc*)m_pDocument;
}
#endif //_DEBUG


// CScienceCamp2014View message handlers


void CScienceCamp2014View::OnBnClickedBtnEncrypt()
{

	int i = 0;

	if (((CButton *)GetDlgItem(IDC_RDO_CAESAR))->GetCheck() == true) {
		CaesarEncrypt();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_SUBSTITUTION))->GetCheck() == true) {
		SubstitutionEncrypt();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_VIGENERE))->GetCheck() == true) {
		//SubstitutionEncrypt();
		i = 1;
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_RAILFENCE))->GetCheck() == true) {
		//SubstitutionEncrypt();
		i = 1;
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_COLUMNTRANSPOSE))->GetCheck() == true) {
		//SubstitutionEncrypt();
		i = 1;
	}

}




void CScienceCamp2014View::OnBnClickedBtnDecrypt()
{
	int i = 0;

	if (((CButton *)GetDlgItem(IDC_RDO_CAESAR))->GetCheck() == true) {
		CaesarDecrypt();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_SUBSTITUTION))->GetCheck() == true) {
		SubstitutionDecrypt();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_VIGENERE))->GetCheck() == true) {
		//SubstitutionEncrypt();
		i = 1;
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_RAILFENCE))->GetCheck() == true) {
		//SubstitutionEncrypt();
		i = 1;
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_COLUMNTRANSPOSE))->GetCheck() == true) {
		//SubstitutionEncrypt();
		i = 1;
	}
}

void CScienceCamp2014View::OnBnClickedBtnAnalyze()
{
	// TODO: Add your control notification handler code here
	ResizeControls();
}


//*****************
/*Encrypt button*/
//*****************

void CScienceCamp2014View::CaesarEncrypt()
{
	// TODO: Add your control notification handler code here
	int i, j, len;
	CEdit* txtPlain = (CEdit *)GetDlgItem(IDC_TXT_PLAIN);
	CEdit* txtKey = (CEdit *)GetDlgItem(IDC_TXT_KEY);
	CEdit* txtCrypt = (CEdit *)GetDlgItem(IDC_TXT_CYPHERTXT);

	CString myString;
	txtPlain->GetWindowText(myString);
	wchar_t *s = (wchar_t *)myString.GetBuffer();
	len = myString.GetLength();
	wchar_t *crypt = new wchar_t[2*len + 1];

	CString myNum;
	txtKey->GetWindowText(myNum);
	int caesarShift = _wtoi(myNum);

	if (this->mChkPreserve.GetCheck() == true) {
		for (i = 0; i < len; i++){
			if (s[i] >= 'A' && s[i] <= 'Z'){
				crypt[i] = 'A' + (s[i] - 'A' + caesarShift) % 26;
			}
			else if (s[i] >= 'a' && s[i] <= 'z'){
				crypt[i] = 'a' + (s[i] - 'a' + caesarShift) % 26;
			}
			else { crypt[i] = s[i]; }
		}
		crypt[len] = 0;
	}
	else{
		j = 0;
		for (i = 0; i < len; i++){
			if (s[i] >= 'A' && s[i] <= 'Z'){
				crypt[j] = 'A' + (s[i] - 'A' + caesarShift) % 26;
				j++;
			}
			else if (s[i] >= 'a' && s[i] <= 'z'){
				crypt[j] = 'A' + (s[i] - 'a' + caesarShift) % 26;
				j++;
			}
			if (j % 5 == 4){ crypt[j] = ' '; j++; }
		}
		crypt[j] = 0;
	}

	txtCrypt->SetWindowTextW(crypt);
	delete[] crypt;
}

void CScienceCamp2014View::SubstitutionEncrypt()
{
	int i, j, len;

	CString plainString,keyString;
	mTxtPlain.GetWindowText(plainString);
	wchar_t *s = (wchar_t *)plainString.GetBuffer();
	len = plainString.GetLength();
	wchar_t *crypt = new wchar_t[2 * len + 1];
	mTxtKey.GetWindowText(keyString);
	keyString = keyString.MakeUpper();
	keyString = keyString.SpanIncluding(_T("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
	wchar_t *key = (wchar_t *) keyString.GetBuffer();

	if (keyString.GetLength() < 26){
		CString errorStr("Error, expected a key with 26 letters for a substitution cypher.");
		AfxMessageBox(errorStr, MB_OK, 0);
	}
	else{
		if (this->mChkPreserve.GetCheck() == true) {
			for (i = 0; i < len; i++){
				if (s[i] >= 'A' && s[i] <= 'Z'){
					crypt[i] = key[s[i]-'A'];
				}
				else if (s[i] >= 'a' && s[i] <= 'z'){
					crypt[i] = key[s[i] - 'a'];
				}
				else { crypt[i] = s[i]; }
			}
			crypt[len] = 0;
		}
		else{
			j = 0;
			for (i = 0; i < len; i++){
				if (s[i] >= 'A' && s[i] <= 'Z'){
					crypt[j] = key[s[i] - 'A'];
					j++;
				}
				else if (s[i] >= 'a' && s[i] <= 'z'){
					crypt[j] = key[s[i] - 'a'];
					j++;
				}
				if (j % 5 == 4){ crypt[j] = ' '; j++; }
			}
			crypt[j] = 0;
		}

	}
	
	mTxtCypher.SetWindowTextW(crypt);
	delete[] crypt;


}

//*****************
/*Decrypt button*/
//*****************

void CScienceCamp2014View::CaesarDecrypt()
{
	int i, len;
	CEdit* txtPlain = (CEdit *)GetDlgItem(IDC_TXT_PLAIN);
	CEdit* txtKey = (CEdit *)GetDlgItem(IDC_TXT_KEY);
	CEdit* txtCrypt = (CEdit *)GetDlgItem(IDC_TXT_CYPHERTXT);

	CString myString;
	txtCrypt->GetWindowText(myString);
	wchar_t *s = (wchar_t *)myString.GetBuffer();
	len = myString.GetLength();
	wchar_t *plain = new wchar_t[len + 1];

	CString myNum;
	txtKey->GetWindowText(myNum);
	int caesarShift = _wtoi(myNum);

	for (i = 0; i < len; i++){
		if (s[i] >= 'A' && s[i] <= 'Z'){
			plain[i] = 'A' + (s[i] - 'A' - caesarShift) % 26;
		}
		else if (s[i] >= 'a' && s[i] <= 'z'){
			plain[i] = 'a' + (s[i] - 'a' - caesarShift) % 26;
		}
		else { plain[i] = s[i]; }
	}
	plain[len] = 0;

	txtPlain->SetWindowTextW(plain);
	delete[] plain;
}


void CScienceCamp2014View::SubstitutionDecrypt()
{
	int i, j, len, val,err=false;

	CString cryptString, keyString;
	mTxtCypher.GetWindowText(cryptString);
	wchar_t *s = (wchar_t *)cryptString.GetBuffer();
	len = cryptString.GetLength();
	wchar_t *plain = new wchar_t[len + 1];
	mTxtKey.GetWindowText(keyString);
	keyString = keyString.MakeUpper();
	keyString = keyString.SpanIncluding(_T("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
	keyString.Truncate(26);
	wchar_t *dualKey = new wchar_t[27];
	for (i = 0; i < 26; i++){
		val = keyString.Find('A' + i, 0);
		if (val > -1){
			dualKey[i] = 'A' + val;
		}
		else{
			dualKey[i] = '?'; err = true;
		}
	}
	dualKey[26] = 0;
	if (err == true){
		CString errorStr("Some letters did not have inverses");
		AfxMessageBox(errorStr, MB_OK, 0);
	}


	j = 0;
	for (i = 0; i < len; i++){
		if (s[i] >= 'A' && s[i] <= 'Z'){
			plain[j] = dualKey[s[i] - 'A'];
			j++;
		}
		else if (s[i] >= 'a' && s[i] <= 'z'){
			plain[j] = dualKey[s[i] - 'a'];
			j++;
		}
	}
	plain[j] = 0;



	mTxtPlain.SetWindowTextW(plain);
	delete[] plain;
}

//*****************
/*Analyze*/
//*****************


//*****************
/*Other*/
//*****************

void CScienceCamp2014View::ResizeControls()
{
	CRect tempRect;
	this->GetWindowRect(&tempRect);
	int ht = tempRect.bottom - tempRect.top;
	int wdth = tempRect.right - tempRect.left;

	tempRect.left = wdth * 2 / 5;
	this->mTxtPlain.SetWindowPos(NULL, 0, 165, wdth * 2 / 5, ht - 165, 0);

	int i = 0;

}
